IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_COMIS_RECALC_REGRESSAO]')
          AND type IN(N'P', N'PC')
)
    BEGIN
        DROP PROCEDURE [dbo].[P_PDV_VD_IT_COMIS_RECALC_REGRESSAO]
    END;
GO 
CREATE  PROCEDURE [dbo].[P_PDV_VD_IT_COMIS_RECALC_REGRESSAO] (   @CD_EMP      INT = 1,
										   @CD_FILIAL   VARCHAR(MAX), 
										   @CD_FUN      VARCHAR(MAX)='',                           
										   @DT_INI      DATETIME = NULL,
										   @DT_FIM      DATETIME = NULL,
										   @CD_PROD     INT=0) 

--Processo de procedure criada especificadamente ao cliente cristina devido ambiente de memria reduzido ao para execuo do processo : 04/03/2020 

AS
SET NOCOUNT ON  
--BEGIN TRY
BEGIN

DECLARE @CD_EMP_RS		INT
DECLARE @CD_FILIAL_RS	INT
DECLARE @CD_VD_RS		INT
DECLARE @CD_PROD_RS		INT
DECLARE @CD_VEND		INT
DECLARE @CD_VEND_RS		INT
DECLARE @CD_IT_RS INT
DECLARE @PERC_COMIS MONEY
DECLARE @DS_PERC_COMIS VARCHAR(100)
DECLARE @VLR_COMISSAO_FABRIC MONEY
DECLARE @DS_VLR_COMIS VARCHAR(100)
DECLARE @DS_PROD VARCHAR(200)
DECLARE @CD_VEND_PADRAO INT
DECLARE @FLAG_COMISSAO_OPERADOR INT
DECLARE @TIPO_PROC_COMISSAO INT
 

print 'Inicio do processo = '+ convert (varchar ,getdate (),108)

--Se nao tem regressao de comissao ... sai
if not exists (select top 1 * from EST_PROD_TBL_COMIS_REGRESSAO )
	return;


SELECT 	CD_EMP, 
		CD_FILIAL, 
		CD_PROD
		INTO #VIEW_COMIS_POSSUI
  FROM V_EST_PROD_TBL_COMIS_POSSUI
 WHERE CD_EMP =  1 
   AND TIPO_COMISSAO=2
   

CREATE INDEX IX_PESQUISA_01 ON [dbo].[#VIEW_COMIS_POSSUI] ([CD_EMP],[CD_FILIAL],[CD_PROD]);


SET @FLAG_COMISSAO_OPERADOR=0
IF EXISTS(SELECT
			TOP 1 FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_CARGO
		FROM
			FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO INNER JOIN FP_CARGO ON
			FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_EMP = FP_CARGO.CD_EMP AND
			FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO.CD_CARGO = FP_CARGO.CD_CARGO 
		WHERE
			TP_CARGO=4)
begin
	SET @FLAG_COMISSAO_OPERADOR=1
end

create table #tmp_filial(cd_emp int, cd_filial int, tp_regressao int)
create table #tmp_vend(cd_fun int)

	insert into #tmp_filial
	SELECT @CD_EMP, ID , 0 FROM UFD_PRM_IN_STRING(@CD_FILIAL)

	update t set tp_regressao=1
	from #tmp_filial t
		join (SELECT cd_emp, cd_filial 
				FROM PRC_FILIAL_CONFIG 
				WHERE CD_CHAVE='COMISSAO_TIPO_REGRESSIVO' AND VALOR ='1') r on 
		t.cd_emp	= r.cd_emp and
		t.cd_filial = r.cd_filial

	insert into #tmp_vend
	 SELECT ID FROM UFD_PRM_IN_STRING(@CD_FUN) 

CREATE TABLE #VendaComissao (CD_EMP INT,
							 CD_FILIAL INT,
							 CD_VD INT,
							 CD_IT INT,
							 CD_PROD INT,
							 CD_VEND INT,
							 TX_DESC MONEY,
							 TX_DESC_CAD MONEY,
							 PERC_COMIS_VENDA MONEY,
							 VLR_COMISSAO_FABRIC_VENDA MONEY,
							 TIPO_PROC_COMISSAO INT,
							 TP_DESCONTO TINYINT)

							 print 'processo2 = '+ convert (varchar ,getdate (),108)

 IF LTRIM(RTRIM(@CD_FUN))<>''
 begin
 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
	   a.CD_IT,
       a.CD_PROD,
       a.CD_VEND,
	   A.TX_DESC,
	   A.PERC_DESC_MIN,
	   A.PERC_COMIS,
	   A.VLR_COMISSAO_FABRIC,
	   0 AS TIPO_COMISSAO,
	   A.TIPO_DESCONTO
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_vend v on
	  v.cd_fun= a.CD_VEND  
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP   
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
	  INNER JOIN #VIEW_COMIS_POSSUI pc ON
	  A.CD_EMP = pc.CD_EMP AND 
	  A.CD_FILIAL = pc.CD_FILIAL AND
	  A.CD_PROD = pc.CD_PROD 
	  /*AND pc.TIPO_COMISSAO=2*/
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END

	    
	  
 --Quando o vendedor mudou o cargo para que nao tem comissao ao longo do periodo

 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
	   a.CD_IT,
       a.CD_PROD,
       a.CD_VEND,
	   A.TX_DESC,
	   A.PERC_DESC_MIN,
	   A.PERC_COMIS,
	   A.VLR_COMISSAO_FABRIC,
	   0 AS TIPO_COMISSAO,
	   A.TIPO_DESCONTO
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_vend v on
	  v.cd_fun= a.CD_VEND  
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP   
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  LEFT OUTER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
	  AND cc.CD_CARGO IS NULL 

 
		IF @FLAG_COMISSAO_OPERADOR=1
		begin
		   INSERT INTO #VendaComissao
		   SELECT  DISTINCT a.CD_EMP,
			   a.CD_FILIAL,
			   a.CD_VD,
			   a.CD_IT,
			   a.CD_PROD,
			   FP_FUNC.CD_FUN ,
			   A.TX_DESC,
			   A.PERC_DESC_MIN,
			   PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.PERC_COMI,
			   PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.VLR_COMISSAO_FABRIC,
			   1 AS TIPO_COMISSAO,
			   A.TIPO_DESCONTO
		  FROM 
			  PDV_VD_IT a INNER JOIN PDV_VD ON
			  a.CD_EMP= PDV_VD.CD_EMP AND
			  a.CD_FILIAL = PDV_VD.CD_FILIAL AND
			  a.CD_VD = PDV_VD.CD_VD AND
			  a.DT_VD = PDV_VD.DT_VD
			  inner join #tmp_vend v on
			  v.cd_fun= a.CD_VEND  
			  LEFT OUTER JOIN PDV_VD_IT_OPERADOR_CAIXA_COMISSAO ON
			  a.CD_EMP= PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_EMP AND
			  a.CD_FILIAL = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_FILIAL AND
			  a.CD_VD = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_VD AND
			  a.CD_IT = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_IT
			  inner join #tmp_filial L on
			  A.CD_FILIAL= L.CD_FILIAL AND
			  A.CD_EMP	 = L.CD_EMP   
			  INNER JOIN FP_FUNC ON
			  PDV_VD.CD_EMP = FP_FUNC.CD_EMP AND
			  PDV_VD.CD_USU_OPE = FP_FUNC.CD_FUNC_USU 
			  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
			  FP_FUNC.CD_EMP = cc.CD_EMP AND
			  FP_FUNC.CD_CARGO = cc.CD_CARGO
			  INNER JOIN #VIEW_COMIS_POSSUI pc ON
			  A.CD_EMP = pc.CD_EMP AND 
			  A.CD_FILIAL = pc.CD_FILIAL AND
			  A.CD_PROD = pc.CD_PROD 
			  /*AND  pc.TIPO_COMISSAO=2*/
		  WHERE
			  a.CD_EMP = @CD_EMP
			  AND A.DT_VD between @DT_INI AND @DT_FIM 
			  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
		end
end
	 
IF LTRIM(RTRIM(@CD_FUN))=''
  begin
 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
	   a.CD_IT,
       a.CD_PROD,
       a.CD_VEND,
	   A.TX_DESC,
	   A.PERC_DESC_MIN,
	   A.PERC_COMIS,
	   A.VLR_COMISSAO_FABRIC,
	   0 AS TIPO_COMISSAO,
	   A.TIPO_DESCONTO
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP   
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
	  INNER JOIN #VIEW_COMIS_POSSUI pc ON
	  A.CD_EMP = pc.CD_EMP AND 
	  A.CD_FILIAL = pc.CD_FILIAL AND
	  A.CD_PROD = pc.CD_PROD
	  /* AND pc.TIPO_COMISSAO=2*/
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
--Quando o vendedor mudou o cargo para que nao tem comissao ao longo do periodo
 INSERT INTO #VendaComissao
   SELECT  DISTINCT a.CD_EMP,
       a.CD_FILIAL,
       a.CD_VD,
	   a.CD_IT,
       a.CD_PROD,
       a.CD_VEND,
	   A.TX_DESC,
	   A.PERC_DESC_MIN,
	   A.PERC_COMIS,
	   A.VLR_COMISSAO_FABRIC,
	   0 AS TIPO_COMISSAO,
	   A.TIPO_DESCONTO
  FROM 
	  PDV_VD_IT a 
	  inner join #tmp_filial L on
	  A.CD_FILIAL= L.CD_FILIAL AND
	  A.CD_EMP	 = L.CD_EMP   
	  INNER JOIN FP_FUNC ON
	  A.CD_EMP = FP_FUNC.CD_EMP AND
	  A.CD_VEND = FP_FUNC.CD_FUN 
	  LEFT OUTER JOIN FP_CARGO_EST_PROD_TBL_COMIS cc ON
	  FP_FUNC.CD_EMP = cc.CD_EMP AND
	  FP_FUNC.CD_CARGO = cc.CD_CARGO
  WHERE
      a.CD_EMP = @CD_EMP
      AND A.DT_VD between @DT_INI AND @DT_FIM
	  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
	  AND cc.CD_CARGO IS NULL


	  	  UPDATE #VendaComissao
  SET 
      TX_DESC = ISNULL(TX_DESC, 0), 
      TX_DESC_CAD = ISNULL(TX_DESC_CAD, 0), 
      PERC_COMIS_VENDA = ISNULL(PERC_COMIS_VENDA, 0), 
      VLR_COMISSAO_FABRIC_VENDA = ISNULL(VLR_COMISSAO_FABRIC_VENDA, 0);


	IF @FLAG_COMISSAO_OPERADOR=1
	begin
	    
	   INSERT INTO #VendaComissao
	   SELECT  DISTINCT a.CD_EMP,
		   a.CD_FILIAL,
		   a.CD_VD,
		   a.CD_IT,
		   a.CD_PROD,
		   FP_FUNC.CD_FUN ,
		   A.TX_DESC,
		   A.PERC_DESC_MIN,
		   PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.PERC_COMI,
		   PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.VLR_COMISSAO_FABRIC,
		   1 AS TIPO_COMISSAO,
		   A.TIPO_DESCONTO
	  FROM 
		  PDV_VD_IT a INNER JOIN PDV_VD ON
		  a.CD_EMP= PDV_VD.CD_EMP AND
		  a.CD_FILIAL = PDV_VD.CD_FILIAL AND
		  a.CD_VD = PDV_VD.CD_VD AND
		  a.DT_VD = PDV_VD.DT_VD
		  LEFT OUTER JOIN PDV_VD_IT_OPERADOR_CAIXA_COMISSAO ON
		  a.CD_EMP= PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_EMP AND
		  a.CD_FILIAL = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_FILIAL AND
		  a.CD_VD = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_VD AND
		  a.CD_IT = PDV_VD_IT_OPERADOR_CAIXA_COMISSAO.CD_IT
		  inner join #tmp_filial L on
		  A.CD_FILIAL= L.CD_FILIAL AND
		  A.CD_EMP	 = L.CD_EMP   
		  INNER JOIN FP_FUNC ON
		  PDV_VD.CD_EMP = FP_FUNC.CD_EMP AND
		  PDV_VD.CD_USU_OPE = FP_FUNC.CD_FUNC_USU 
		  INNER JOIN FP_CARGO_EST_PROD_TBL_COMIS_REGRESSAO cc ON
		  FP_FUNC.CD_EMP = cc.CD_EMP AND
		  FP_FUNC.CD_CARGO = cc.CD_CARGO
		  INNER JOIN #VIEW_COMIS_POSSUI pc ON
		  A.CD_EMP = pc.CD_EMP AND 
		  A.CD_FILIAL = pc.CD_FILIAL AND
		  A.CD_PROD = pc.CD_PROD 
		 /*AND pc.TIPO_COMISSAO=2*/
	  WHERE
		  a.CD_EMP = @CD_EMP
		  AND A.DT_VD between @DT_INI AND @DT_FIM
		  AND A.CD_PROD = CASE WHEN @CD_PROD=0 THEN A.CD_PROD ELSE @CD_PROD END
		  --OPTION (QUERYTRACEON 4139)

	end
end
 
------------------------------------------------------------------------------------------------------------------------
--COMISSAO_TIPO_REGRESSIVO

UPDATE v
  SET 
      TX_DESC = ISNULL(TX_DESC, 0), 
      TX_DESC_CAD =CASE WHEN tp_regressao=1 THEN 0 ELSE ISNULL(TX_DESC_CAD, 0) END, 
      PERC_COMIS_VENDA = ISNULL(PERC_COMIS_VENDA, 0), 
      VLR_COMISSAO_FABRIC_VENDA = ISNULL(VLR_COMISSAO_FABRIC_VENDA, 0)
from 
	 #VendaComissao v
	 inner join #tmp_filial L on
		  v.CD_FILIAL= L.CD_FILIAL AND
		  v.CD_EMP	 = L.CD_EMP
		  
DELETE FROM v
	FROM #VendaComissao v 
	 inner join #tmp_filial L on
		  v.CD_FILIAL= L.CD_FILIAL AND
		  v.CD_EMP	 = L.CD_EMP
WHERE TX_DESC=0
	and l.tp_regressao=1;

DELETE FROM v
	FROM #VendaComissao v 
	 inner join #tmp_filial L on
		  v.CD_FILIAL= L.CD_FILIAL AND
		  v.CD_EMP	 = L.CD_EMP
WHERE TX_DESC=0
	and l.tp_regressao=1;

------------------------------------------------------------------------------------------------------------------------
--Remove os tipos de desconto nao vinculados a regressao

	delete from v
	FROM #VendaComissao v 
	 inner join EST_GRP_COMIS_DESC_REGRESSAO c on 
	 v.TP_DESCONTO = c.TP_DESCONTO
	 where c.VINCULADO=0

------------------------------------------------------------------------------------------------------------------------

--Debug
--SELECT * FROM #VendaComissao WHERE cd_vd =4646701
------------------------------------------------------------------------------------------------------------------------
-- Gravando a pontuao de vendas
------------------------------------------------------------------------------------------------------------------------
--Nome do cursor


DECLARE ComissaoItensRegressao CURSOR FAST_FORWARD FOR
-- Select utilizado para o cursor
SELECT  DISTINCT a.CD_EMP,
    a.CD_FILIAL,
    a.CD_VD,
	a.CD_IT,
    a.CD_PROD,
    a.CD_VEND,
	ISNULL(F.PERC_COMIS,0),
	ISNULL(F.DS_COMIS_PERC,'NAO DEFINIDO'),
	ISNULL(F.VLR_COMIS,0),
	ISNULL(F.DS_COMIS_VLR,'NAO DEFINIDO'),
	EST_PROD.DS_PROD,
	TIPO_PROC_COMISSAO
FROM 
	#VendaComissao a INNER JOIN EST_PROD ON
	a.CD_EMP = EST_PROD.CD_EMP AND
	a.CD_PROD = EST_PROD.CD_PROD 
	CROSS APPLY UFD_EST_PROD_COMIS_REGRESSAO(A.CD_EMP, a.CD_FILIAL, a.CD_PROD, a.CD_VEND,A.TX_DESC,A.TX_DESC_CAD) F 
WHERE
	(A.PERC_COMIS_VENDA <> ISNULL(F.PERC_COMIS,0)
	OR A.VLR_COMISSAO_FABRIC_VENDA <> ISNULL(F.VLR_COMIS,0))
  


  --Abrindo cursor
  OPEN ComissaoItensRegressao

  --Atribuindo valores do select nas variveis
  FETCH NEXT FROM ComissaoItensRegressao INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD,@TIPO_PROC_COMISSAO


  --Iniciando lao
  WHILE @@FETCH_STATUS = 0
   BEGIN   
		IF @TIPO_PROC_COMISSAO=0
		begin
			print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' Vendedor.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD + ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.:  ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS)
			UPDATE I
				SET 
					I.PERC_COMIS =  @PERC_COMIS,
					I.PERC_COMI = @PERC_COMIS,
					I.DS_PERC_COMIS = @DS_PERC_COMIS,
					I.VLR_COMISSAO_FABRIC =@VLR_COMISSAO_FABRIC ,
					I.DS_VLR_COMIS = @DS_VLR_COMIS
				FROM  PDV_VD_IT I
				WHERE I.CD_EMP = @CD_EMP_RS
						AND I.CD_FILIAL = @CD_FILIAL_RS        
						AND I.CD_VD = @CD_VD_RS
						AND I.CD_VEND = @CD_VEND_RS
						AND I.CD_IT = @CD_IT_RS
						AND I.CD_PROD = @CD_PROD_RS
		end
		else
		begin
			print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' operador caixa.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD + ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.:  ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS)

			DELETE 
				I
			FROM 
				PDV_VD_IT_OPERADOR_CAIXA_COMISSAO I
			WHERE 
				I.CD_EMP = @CD_EMP_RS
				AND I.CD_FILIAL = @CD_FILIAL_RS        
				AND I.CD_VD = @CD_VD_RS
				AND I.CD_IT = @CD_IT_RS

			INSERT INTO PDV_VD_IT_OPERADOR_CAIXA_COMISSAO
			(CD_EMP,
			CD_FILIAL,
			CD_VD,
			CD_IT,
			PERC_COMI,
			DS_PERC_COMIS,
			DS_VLR_COMIS,
			VLR_COMISSAO_FABRIC,
			CD_USU)
			SELECT
				@CD_EMP_RS,
				@CD_FILIAL_RS,        
				@CD_VD_RS,
				@CD_IT_RS,
				@PERC_COMIS,
				@DS_PERC_COMIS,
				@DS_VLR_COMIS,
				@VLR_COMISSAO_FABRIC,
				1
		end
      --Prxima linha do cursor
	FETCH NEXT FROM ComissaoItensRegressao INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD,@TIPO_PROC_COMISSAO
  
   END

  CLOSE ComissaoItensRegressao
  DEALLOCATE ComissaoItensRegressao 

--Nome do cursor para devoluo
DECLARE ComissaoItensRegressaoDev CURSOR FOR
 --Select utilizado para o cursor
  SELECT
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP,
	PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL,
	PDV_VD_DEV_EST_PROD_IMP.CD_VD,
	PDV_VD_DEV_EST_PROD_IMP.CD_IT,
	PDV_VD_DEV_EST_PROD_IMP.CD_PROD,
	PDV_VD_DEV_EST_PROD_IMP.CD_VEND,
	ISNULL(PDV_VD_IT.PERC_COMIS,0),
	ISNULL(PDV_VD_IT.DS_PERC_COMIS,'NAO DEFINIDO'),
	ISNULL(PDV_VD_IT.VLR_COMISSAO_FABRIC,0),
	ISNULL(PDV_VD_IT.DS_VLR_COMIS,'NAO DEFINIDO'),
	EST_PROD.DS_PROD
FROM
	PDV_VD_DEV_EST_PROD_IMP INNER JOIN PDV_VD_IT ON
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP=PDV_VD_IT.CD_EMP AND
	PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
	PDV_VD_DEV_EST_PROD_IMP.CD_VD = PDV_VD_IT.CD_VD AND
	PDV_VD_DEV_EST_PROD_IMP.CD_PROD = PDV_VD_IT.CD_PROD AND
	PDV_VD_DEV_EST_PROD_IMP.CD_IT = PDV_VD_IT.CD_IT
	inner join #tmp_filial L on
	PDV_VD_DEV_EST_PROD_IMP.CD_FILIAL= L.CD_FILIAL AND
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP	 = L.CD_EMP   
	INNER JOIN EST_PROD ON
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP = EST_PROD.CD_EMP AND
	PDV_VD_DEV_EST_PROD_IMP.CD_PROD = EST_PROD.CD_PROD 
WHERE
	PDV_VD_DEV_EST_PROD_IMP.CD_EMP=@CD_EMP
	AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO between @DT_INI AND @DT_FIM
    AND PDV_VD_DEV_EST_PROD_IMP.CD_PROD = CASE WHEN @CD_PROD=0 THEN PDV_VD_DEV_EST_PROD_IMP.CD_PROD ELSE @CD_PROD END
	AND (PDV_VD_DEV_EST_PROD_IMP.PERC_COMIS <> PDV_VD_IT.PERC_COMIS 
	OR PDV_VD_DEV_EST_PROD_IMP.VLR_COMISSAO_FABRIC <> PDV_VD_IT.VLR_COMISSAO_FABRIC )	
  
  --Abrindo cursor
  OPEN ComissaoItensRegressaoDev
  
--Atribuindo valores do select nas variveis
FETCH NEXT FROM ComissaoItensRegressaoDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
												@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
												@PERC_COMIS,@DS_PERC_COMIS,
												@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD

  --Iniciando lao
  WHILE @@FETCH_STATUS = 0
   BEGIN   
	print 'Filial ' + convert(varchar(100), @CD_FILIAL_RS) +  ' Devolucao Vendedor.: ' + convert(varchar(100), @CD_VEND_RS) + ' produto.: ' + convert(varchar(100), @CD_PROD_RS) + ' ' + @DS_PROD +  ' tipo comissao.:  ' + @DS_PERC_COMIS + ' descri. comissao.: ' + @DS_VLR_COMIS + ' perc.comissao.: ' + convert(varchar(10),@PERC_COMIS)
		 UPDATE I
		    SET 
				I.PERC_COMIS = @PERC_COMIS,
				I.DS_PERC_COMIS = @DS_PERC_COMIS,
				I.VLR_COMISSAO_FABRIC = @VLR_COMISSAO_FABRIC,
				I.DS_VLR_COMIS = @DS_VLR_COMIS	
		    FROM PDV_VD_DEV_EST_PROD_IMP i			
		    WHERE I.CD_EMP = @CD_EMP_RS
				 AND I.CD_FILIAL = @CD_FILIAL_RS        
				 AND I.CD_VD = @CD_VD_RS
				 AND I.CD_VEND = @CD_VEND_RS
				 AND I.CD_IT = @CD_IT_RS				
				 AND (isnull(I.PERC_COMIS,0) <> @PERC_COMIS OR
					  isnull(I.VLR_COMISSAO_FABRIC,0) <> @VLR_COMISSAO_FABRIC)
      --Prxima linha do cursor
	FETCH NEXT FROM ComissaoItensRegressaoDev INTO @CD_EMP_RS, @CD_FILIAL_RS, @CD_VD_RS, 
								@CD_IT_RS,@CD_PROD_RS, @CD_VEND_RS,
								@PERC_COMIS,@DS_PERC_COMIS,
								@VLR_COMISSAO_FABRIC,@DS_VLR_COMIS,@DS_PROD
    
   END

  CLOSE ComissaoItensRegressaoDev
  DEALLOCATE ComissaoItensRegressaoDev 

  
   	
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_vend') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_vend
	END	
	IF  OBJECT_ID('TEMPDB.DBO.#tmp_filial') IS NOT NULL
	BEGIN
			DROP TABLE #tmp_filial
	END

	IF  OBJECT_ID('TEMPDB.DBO.#VendaComissao') IS NOT NULL
	BEGIN
			DROP TABLE #VendaComissao
	END
	IF  OBJECT_ID('TEMPDB.DBO.#VIEW_COMIS_POSSUI') IS NOT NULL
	BEGIN
			DROP TABLE #VIEW_COMIS_POSSUI
	END	
END
/*
END TRY
BEGIN CATCH
 INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
  SELECT
   ERROR_NUMBER() AS numero,
   ERROR_SEVERITY() AS severidade,
   ERROR_STATE() AS estado,
   ERROR_PROCEDURE() AS rotina,
   ERROR_LINE() AS linha,
   ERROR_MESSAGE() AS mensagem,
   GETDATE() AS dtErro; 
END CATCH
*/

GO


